// Variável para armazenar a lista de compras
let listaCompras = [];

// Função para adicionar um item à lista de compras
function adicionarItem() {
    const item = document.getElementById("itemInput").value;
    const valorUnitario = parseFloat(document.getElementById("valorInput").value);
    const quantidade = parseInt(document.getElementById("quantidadeInput").value);

    if (item && !isNaN(valorUnitario) && !isNaN(quantidade)) {
        const total = valorUnitario * quantidade;
        const novoItem = {
            item,
            valorUnitario,
            quantidade,
            total
        };

        listaCompras.push(novoItem);
        exibirLista();
        atualizarTotalCompra();
        salvarListaNoLocalStorage();
    }

    // Limpar os campos de input
    document.getElementById("itemInput").value = "";
    document.getElementById("valorInput").value = "";
    document.getElementById("quantidadeInput").value = "";
}

// Função para exibir a lista de compras na tabela
function exibirLista() {
    const listaElement = document.getElementById("lista").getElementsByTagName("tbody")[0];
    listaElement.innerHTML = "";

    listaCompras.forEach((item, index) => {
        const row = listaElement.insertRow();

        const itemCell = row.insertCell(0);
        const valorCell = row.insertCell(1);
        const quantidadeCell = row.insertCell(2);
        const totalCell = row.insertCell(3);
        const acoesCell = row.insertCell(4);

        itemCell.innerHTML = item.item;
        valorCell.innerHTML = item.valorUnitario.toFixed(2);
        quantidadeCell.innerHTML = item.quantidade;
        totalCell.innerHTML = item.total.toFixed(2);
        acoesCell.innerHTML = `<button onclick="removerItem(${index})"><i class="bi bi-trash3-fill"></i></button>`;
    });
}

// Função para remover um item da lista de compras
function removerItem(index) {
    listaCompras.splice(index, 1);
    exibirLista();
    atualizarTotalCompra();
    salvarListaNoLocalStorage();
}

// Função para atualizar o total da compra
function atualizarTotalCompra() {
    const totalCompraElement = document.getElementById("totalCompra");
    const totalCompra = listaCompras.reduce((total, item) => total + item.total, 0);
    totalCompraElement.innerHTML = totalCompra.toFixed(2);
}

// Função para salvar a lista de compras no LocalStorage
function salvarListaNoLocalStorage() {
    localStorage.setItem("listaCompras", JSON.stringify(listaCompras));
}

// Função para carregar a lista de compras do LocalStorage (caso exista)
function carregarListaDoLocalStorage() {
    const listaSalva = localStorage.getItem("listaCompras");
    if (listaSalva) {
        listaCompras = JSON.parse(listaSalva);
        exibirLista();
        atualizarTotalCompra();
    }
}

// Carregar a lista de compras do LocalStorage quando a página carregar
document.addEventListener("DOMContentLoaded", carregarListaDoLocalStorage);